<?php
/**
 * 404 page file
 *
 * @package    WordPress
 * @subpackage Antilia
 * @author     Codeliono <admin@template_path.com>
 * @version    1.0
 */

$allowed_html = wp_kses_allowed_html( 'post' );

$icon_img   = $options->get( 'icon_image' );
$icon_img   = antilia_set( $icon_img, 'url', ANTILIA_URI . '' );

?>
<?php get_header('');
$data = \ANTILIA\Includes\Classes\Common::instance()->data( '404' )->get();
$options = antilia_WSH()->option();
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
?>

<?php if ( $data->get( 'enable_banner' ) ) : ?>
	<?php do_action( 'antilia_banner', $data );?>
<?php else:?>
<!-- Page Title -->
<section class="page-title" style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')">
    <div class="auto-container">
        <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( the_title( ) ); ?></h2>
        <?php if(antilia_the_breadcrumb()){ ?>
        <ul class="bread-crumb clearfix">
            <?php echo antilia_the_breadcrumb(); ?>
        </ul>
        <?php } ?>
    </div>
</section>
<!-- End Page Title -->
<?php endif;?>    

<!-- Error Section -->
<div class="error-section">
    <div class="auto-container">
        <div class="content">
            <h1>
            	<?php if( $options->get( '404_page_title' ) ):?>
					<?php echo wp_kses( $options->get( '404_page_title' ), true );?>
                <?php else:?>
                        <?php esc_html_e( '404', 'antilia' );?>
                <?php endif;?>
            </h1>
            <h2>
            	<?php if( $options->get( '404_page_heading' ) ):?>
						<?php echo wp_kses( $options->get( '404_page_heading' ), true );?>
                <?php else:?>
                        <?php esc_html_e( 'Oops... It looks like you ‘re lost !', 'antilia' );?>
                <?php endif;?>
            </h2>
            <div class="text">
            	<?php if( $options->get( '404_page_text' ) ):?>
						<?php echo wp_kses( $options->get( '404_page_text' ), true );?>
                <?php else:?>
                        <?php esc_html_e( 'Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'antilia' );?>
                <?php endif;?>
            </div>
            <?php if ( $options->get( 'back_home_btn', true ) ) : ?>
            <!-- Button Box -->
            <div class="button-box text-center">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="theme-btn btn-style-two">
                    <span class="btn-wrap">
                        <span class="text-one">
                        	<?php 
								if( $options->get( 'back_home_btn_label' ) ){
									echo wp_kses( $options->get( 'back_home_btn_label' ), true );
								}else{
									esc_html_e( 'Go To Home', 'antilia' );
								}
							?>
                        </span>
                        <span class="text-two">
                        	<?php 
								if( $options->get( 'back_home_btn_label' ) ){
									echo wp_kses( $options->get( 'back_home_btn_label' ), true );
								}else{
									esc_html_e( 'Go To Home', 'antilia' );
								}
							?>
                        </span>
                    </span>
                </a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<!-- End Error Section -->

<?php if ( $options->get( 'show_404_bottom_section', true ) ) : ?>
<!-- Marketing One -->
<section class="marketing-one">
    <div class="outer-container">
        <div class="animation_mode_two">
            <?php if( $options->get( '404_marquee_title' ) ):?><h1><?php echo wp_kses( $options->get( '404_marquee_title' ), true );?></h1><?php endif; ?>
            <span class="marketing-one_icon"><img src="<?php echo esc_url($icon_img); ?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" /></span>
            <?php if( $options->get( '404_marquee_title2' ) ):?><h1 class="light"><?php echo wp_kses( $options->get( '404_marquee_title2' ), true );?></h1><?php endif; ?>
            <span class="marketing-one_icon"><img src="<?php echo esc_url($icon_img); ?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" /></span>
            <?php if( $options->get( '404_marquee_title3' ) ):?><h1><?php echo wp_kses( $options->get( '404_marquee_title3' ), true );?> </h1><?php endif; ?>
            <span class="marketing-one_icon"><img src="<?php echo esc_url($icon_img); ?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" /></span>
            <?php if( $options->get( '404_marquee_title4' ) ):?><h1><?php echo wp_kses( $options->get( '404_marquee_title4' ), true );?></h1><?php endif; ?>
        </div>
    </div>
</section>
<!-- End Marketing One -->    
<?php endif; ?>
            
<?php
}
get_footer(''); ?>
