<?php

require_once get_template_directory() . '/includes/loader.php';

add_action( 'after_setup_theme', 'antilia_setup_theme' );
add_action( 'after_setup_theme', 'antilia_load_default_hooks' );


function antilia_setup_theme() {

	load_theme_textdomain( 'antilia', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-header' );
	add_theme_support( 'custom-background' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-lightbox' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'editor-styles' );
	add_theme_support( 'post', 'page-attributes' );
    
	// Set the default content width.
	$GLOBALS['content_width'] = 525;
	
	/*---------- Register image sizes ----------*/
	
	//Register image sizes
	add_image_size( 'antilia_370x485', 370, 485, true ); //antilia_370x485 Team Carousel
	add_image_size( 'antilia_570x330', 570, 330, true ); //antilia_570x330 Project Carousel
	add_image_size( 'antilia_350x330', 370, 330, true ); //antilia_350x330 Project Carousel
	add_image_size( 'antilia_300x390', 300, 390, true ); //antilia_300x390 Project Carousel
	add_image_size( 'antilia_300x257', 300, 257, true ); //antilia_300x257 Project Carousel
	add_image_size( 'antilia_743x477', 743, 477, true ); //antilia_743x477 Project Carousel
	add_image_size( 'antilia_337x196', 337, 196, true ); //antilia_337x196 Project Carousel
	add_image_size( 'antilia_100x100', 100, 100, true ); //antilia_100x100 Testimonial Carousel
	add_image_size( 'antilia_183x371', 183, 371, true ); //antilia_183x371 Testimonial Carousel
	add_image_size( 'antilia_284x218', 284, 218, true ); //antilia_284x218 Blog Grid
	add_image_size( 'antilia_414x307', 414, 307, true ); //antilia_414x307 Blog Grid
	add_image_size( 'antilia_200x130', 200, 130, true ); //antilia_200x130 Blog Grid
	add_image_size( 'antilia_270x270', 270, 270, true ); //antilia_270x270 Shop Page
	add_image_size( 'antilia_80x190', 80, 190, true ); //antilia_80x190 Blog Sidebar Widget
	add_image_size( 'antilia_140x110', 140, 110, true ); //antilia_140x110 Blog Sidebar Widget
	add_image_size( 'antilia_1290x520', 1290, 520, true ); //antilia_1290x520 Blog Classic
	add_image_size( 'antilia_1170x520', 1170, 520, true ); //antilia_1170x520 Blog Classic
	
	/*---------- Register image sizes ends ----------*/
	
	
	
	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'main_menu' => esc_html__( 'Main Menu', 'antilia' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'      => 250,
		'height'     => 250,
		'flex-width' => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style();
	add_action( 'admin_init', 'antilia_admin_init', 2000000 );
}

/**
 * [antilia_admin_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */


function antilia_admin_init() {
	remove_action( 'admin_notices', array( 'ReduxFramework', '_admin_notices' ), 99 );
}

/*---------- Sidebar settings ----------*/

/**
 * [antilia_widgets_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
function antilia_widgets_init() {

	global $wp_registered_sidebars;

	$theme_options = get_theme_mod( 'antilia' . '_options-mods' );

	register_sidebar( array(
		'name'          => esc_html__( 'Default Sidebar', 'antilia' ),
		'id'            => 'default-sidebar',
		'description'   => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'antilia' ),
		'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="sidebar-title"><h5>',
		'after_title'   => '</h5></div>',
	) );
	register_sidebar(array(
		'name' => esc_html__('Footer Widget', 'antilia'),
		'id' => 'footer-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'antilia'),
		'before_widget'=>'<div class="col-lg-4 col-md-6 col-sm-12 footer-column"><div id="%1$s" class="footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h5>',
		'after_title' => '</h5>'
	));
	if ( class_exists( '\Elementor\Plugin' )){	
	register_sidebar(array(
		'name' => esc_html__('Footer Two Widget', 'antilia'),
		'id' => 'footer-sidebar-2',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'antilia'),
		'before_widget'=>'<div class="col-lg-3 col-md-6 col-sm-12 footer-column"><div id="%1$s" class="footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h5>',
		'after_title' => '</h5>'
	));
	register_sidebar(array(
		'name' => esc_html__('Footer Three Widget', 'antilia'),
		'id' => 'footer-sidebar-3',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'antilia'),
		'before_widget'=>'<div class="col-lg-4 col-md-6 col-sm-12 footer-column"><div id="%1$s" class="footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h5>',
		'after_title' => '</h5>'
	));
	register_sidebar(array(
	  'name' => esc_html__( 'Blog Listing', 'antilia' ),
	  'id' => 'blog-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'antilia' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="sidebar-title"><h5>',
	  'after_title' => '</h5></div>'
	));
	}
	if ( ! is_object( antilia_WSH() ) ) {
		return;
	}

	$sidebars = antilia_set( $theme_options, 'custom_sidebar_name' );

	foreach ( array_filter( (array) $sidebars ) as $sidebar ) {

		if ( antilia_set( $sidebar, 'topcopy' ) ) {
			continue;
		}

		$name = $sidebar;
		if ( ! $name ) {
			continue;
		}
		$slug = str_replace( ' ', '_', $name );

		register_sidebar( array(
			'name'          => $name,
			'id'            => sanitize_title( $slug ),
			'before_widget' => '<div id="%1$s" class="%2$s widget sidebar-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="sidebar-title"><h5>',
			'after_title'   => '</h5></div>',
		) );
	}

	update_option( 'wp_registered_sidebars', $wp_registered_sidebars );
}

add_action( 'widgets_init', 'antilia_widgets_init' );

/*---------- Sidebar settings ends ----------*/

/*---------- Gutenberg settings --------
/*---------- Gutenberg settings ends ----------*/

/*---------- Enqueue Styles and Scripts ----------*/

function antilia_enqueue_scripts() {
	$options = antilia_WSH()->option();
	
	$header_meta = get_post_meta( get_the_ID(), 'header_style_settings');
	$header_option = $options->get( 'header_style_settings' );
	$header = ( $header_meta ) ? $header_meta['0'] : $header_option;
		
	if( $options->get( 'main_color_scheme' ) ){
		$maincolor = str_replace( '#', '' , $options->get( 'main_color_scheme' ));
		
	}else{
		$maincolor = str_replace( '#', '' , '#a97300' );
	}
	if( $options->get( 'secondary_color_scheme' ) ){
		$secondcolor = str_replace( '#', '' , $options->get( 'secondary_color_scheme' ));
	}
	else{
		$secondcolor = str_replace( '#', '' , '#444444' );	
	}
	
    //styles
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.css' );
	wp_enqueue_style( 'global', get_template_directory_uri() . '/assets/css/global.css' );
	wp_enqueue_style( 'header', get_template_directory_uri() . '/assets/css/header.css' );
	wp_enqueue_style( 'footer', get_template_directory_uri() . '/assets/css/footer.css' );
	wp_enqueue_style( 'owl', get_template_directory_uri() . '/assets/css/owl.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.css' );
	wp_enqueue_style( 'preloader', get_template_directory_uri() . '/assets/css/preloader.css' );
	wp_enqueue_style( 'antilia-swiper', get_template_directory_uri() . '/assets/css/swiper.min.css' );
	wp_enqueue_style( 'antilia-font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.css' );
	wp_enqueue_style( 'custom-animate', get_template_directory_uri() . '/assets/css/custom-animate.css' );
	wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/assets/css/magnific-popup.css' );
	wp_enqueue_style( 'jquery-bootstrap-touchspin', get_template_directory_uri() . '/assets/css/jquery.bootstrap-touchspin.css' );
	wp_enqueue_style( '07-icomoon', get_template_directory_uri() . '/assets/css/07-icomoon.css' );
	wp_enqueue_style( 'meanmenu', get_template_directory_uri() . '/assets/css/meanmenu.min.css' );
	wp_enqueue_style( 'odometer-theme-default', get_template_directory_uri() . '/assets/css/odometer-theme-default.css' );
	wp_enqueue_style( 'antilia-main', get_stylesheet_uri() );
	wp_enqueue_style( 'antilia-main-style', get_template_directory_uri() . '/assets/css/style.css' );
	wp_enqueue_style( 'antilia-custom', get_template_directory_uri() . '/assets/css/custom.css' );
	wp_enqueue_style( 'antilia-responsive', get_template_directory_uri() . '/assets/css/responsive.css' );
	wp_enqueue_style( 'antilia-tut', get_template_directory_uri() . '/assets/css/tut.css' );
	wp_enqueue_style( 'antilia-color', get_template_directory_uri() . '/assets/css/color.css' );
	wp_enqueue_style( 'antilia-color-settings', get_template_directory_uri() . '/assets/css/color-switcher-design.css' );
	wp_enqueue_style( 'antilia-main-color-scheme', get_template_directory_uri() . '/assets/css/color.php?main_color='.$maincolor.'&second_color='.$secondcolor.'');
	
    //scripts
	wp_enqueue_script( 'jquery-ui-core');
	wp_enqueue_script( 'popper', get_template_directory_uri().'/assets/js/popper.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/assets/js/bootstrap.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'appear', get_template_directory_uri().'/assets/js/appear.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'parallax', get_template_directory_uri().'/assets/js/parallax.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'tilt-jquery', get_template_directory_uri().'/assets/js/tilt.jquery.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-paroller', get_template_directory_uri().'/assets/js/jquery.paroller.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'wow', get_template_directory_uri().'/assets/js/wow.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'antilia-swiper', get_template_directory_uri().'/assets/js/swiper.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'backtotop', get_template_directory_uri().'/assets/js/backtotop.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'odometer', get_template_directory_uri().'/assets/js/odometer.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'parallax-scroll', get_template_directory_uri().'/assets/js/parallax-scroll.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'antilia-gsap', get_template_directory_uri().'/assets/js/gsap.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'splittext', get_template_directory_uri().'/assets/js/SplitText.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'scrolltrigger', get_template_directory_uri().'/assets/js/ScrollTrigger.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'scrolltoplugin', get_template_directory_uri().'/assets/js/ScrollToPlugin.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'scrollsmoother', get_template_directory_uri().'/assets/js/ScrollSmoother.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'magnific-popup', get_template_directory_uri().'/assets/js/magnific-popup.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'nav-tool', get_template_directory_uri().'/assets/js/nav-tool.js', array( 'jquery' ), '2.1.2', true );
    wp_enqueue_script( 'jquery-ui', get_template_directory_uri().'/assets/js/jquery-ui.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-meanmenu', get_template_directory_uri().'/assets/js/jquery.meanmenu.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-marquee', get_template_directory_uri().'/assets/js/jquery.marquee.min.js', array( 'jquery' ), '2.1.2', true );	
	wp_enqueue_script( 'jquery-countdown', get_template_directory_uri().'/assets/js/jquery.countdown.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'color-settings', get_template_directory_uri().'/assets/js/color-settings.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'antilia-main-script', get_template_directory_uri().'/assets/js/script.js', array(), false, true );
	wp_enqueue_script( 'antilia-cooke', get_template_directory_uri().'/assets/js/jquery.cookie.js', array(), false, true );
	wp_enqueue_script( 'antilia-color-panel', get_template_directory_uri().'/assets/js/color-panel.js', array(), false, true );
	if( is_singular() ) wp_enqueue_script('comment-reply');
}
add_action( 'wp_enqueue_scripts', 'antilia_enqueue_scripts' );

/*---------- Enqueue styles and scripts ends ----------*/

/*---------- Google fonts ----------*/

function antilia_fonts_url() {
	
	$fonts_url = ''; 
		
		$font_families['Anybody']	= 'Anybody:300,400,500,600,700,800,900';
		
		
		$font_families = apply_filters( 'ANTILIA/includes/classes/header_enqueue/font_families', $font_families );

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$protocol  = is_ssl() ? 'https' : 'http';
		$fonts_url = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css' );

		return esc_url_raw($fonts_url);

}

function antilia_theme_styles() {
    wp_enqueue_style( 'antilia-theme-fonts', antilia_fonts_url(), array(), null );
}

add_action( 'wp_enqueue_scripts', 'antilia_theme_styles' );
add_action( 'admin_enqueue_scripts', 'antilia_theme_styles' );

/*---------- Google fonts ends ----------*/

/*---------- More functions ----------*/

// 1) antilia_set function

/**
 * [antilia_set description]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
if ( ! function_exists( 'antilia_set' ) ) {
	function antilia_set( $var, $key, $def = '' ) {

		if ( is_object( $var ) && isset( $var->$key ) ) {
			return $var->$key;
		} elseif ( is_array( $var ) && isset( $var[ $key ] ) ) {
			return $var[ $key ];
		} elseif ( $def ) {
			return $def;
		} else {
			return false;
		}
	}
}

// 2) antilia_add_editor_styles function

function antilia_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'antilia_add_editor_styles' );

// 3) Add specific CSS class by filter body class.

$options = antilia_WSH()->option(); 
if( antilia_set($options, 'boxed_wrapper') ){

add_filter( 'body_class', function( $classes ) {
    $classes[] = 'boxed_wrapper';
    return $classes;
} );
}




function antilia_related_products_limit() {
  global $product;
	
	$args['posts_per_page'] = 6;
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'antilia_related_products_args', 20 );
  function antilia_related_products_args( $args ) {
	$args['posts_per_page'] = 3; // 4 related products
	$args['columns'] = 1; // arranged in 2 columns
	return $args;
}
