<?php

return array(
	'title'      => esc_html__( '404 Page Settings', 'antilia' ),
	'id'         => '404_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => '404_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( '404 Source Type', 'antilia' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'antilia' ),
				'e' => esc_html__( 'Elementor', 'antilia' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => '404_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'antilia' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
			],
			'required' => [ '404_source_type', '=', 'e' ],
		),
		array(
			'id'       => '404_default_st',
			'type'     => 'section',
			'title'    => esc_html__( '404 Default', 'antilia' ),
			'indent'   => true,
			'required' => [ '404_source_type', '=', 'd' ],
		),
		array(
			'id'      => '404_page_banner',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Banner', 'antilia' ),
			'desc'    => esc_html__( 'Enable to show banner on blog', 'antilia' ),
			'default' => true,
		),
		array(
			'id'       => '404_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Banner Section Title', 'antilia' ),
			'desc'     => esc_html__( 'Enter the title to show in banner section', 'antilia' ),
			'required' => array( '404_page_banner', '=', true ),
		),
		array(
			'id'       => '404_page_background',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'antilia' ),
			'desc'     => esc_html__( 'Insert background image for banner', 'antilia' ),
			'required' => array( '404_page_banner', '=', true ),
		),		
		array(
			'id'    => '404_page_title',
			'type'  => 'text',
			'title' => esc_html__( '404 Page Title', 'antilia' ),
			'desc'  => esc_html__( 'Enter 404 page title that you want to show.', 'antilia' ),
		),
		array(
			'id'    => '404_page_heading',
			'type'  => 'text',
			'title' => esc_html__( '404 Page Heading', 'antilia' ),
			'desc'  => esc_html__( 'Enter 404 page heading that you want to show.', 'antilia' ),
		),
		array(
			'id'    => '404_page_text',
			'type'  => 'textarea',
			'title' => esc_html__( '404 Page Description', 'antilia' ),
			'desc'  => esc_html__( 'Enter 404 page description that you want to show.', 'antilia' ),
		),	
		array(
			'id'    => 'back_home_btn',
			'type'  => 'switch',
			'title' => esc_html__( 'Show Button', 'antilia' ),
			'desc'  => esc_html__( 'Enable to show back to home button.', 'antilia' ),
			'default'  => true,
		),
		array(
			'id'       => 'back_home_btn_label',
			'type'     => 'text',
			'title'    => esc_html__( 'Button Label', 'antilia' ),
			'desc'     => esc_html__( 'Enter back to home button label that you want to show.', 'antilia' ),
			'default'  => esc_html__( 'Go To Home', 'antilia' ),
			'required' => array( 'back_home_btn', '=', true ),
		),
		
		array(
			'id'    => 'show_404_bottom_section',
			'type'  => 'switch',
			'title' => esc_html__( 'Show Bottom Marquee Section', 'antilia' ),
			'desc'  => esc_html__( 'Enable to Show Bottom Marquee Section.', 'antilia' ),
			'default'  => true,
		),
		array(
			'id'       => 'icon_image',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Bottom Marquee Icon Image', 'antilia' ),
			'desc'     => esc_html__( 'Bottom marquee icon image', 'antilia' ),
			'default'  => '',
			'required' => array( 'show_404_bottom_section', '=', true ),
		),
		array(
			'id'    => '404_marquee_title',
			'type'  => 'text',
			'title' => esc_html__( '404 Page Marquee Title', 'antilia' ),
			'desc'  => esc_html__( 'Enter 404 page marquee title that you want to show.', 'antilia' ),
			'required' => array( 'show_404_bottom_section', '=', true ),
		),
		array(
			'id'    => '404_marquee_title2',
			'type'  => 'text',
			'title' => esc_html__( '404 Page Marquee Title', 'antilia' ),
			'desc'  => esc_html__( 'Enter 404 page marquee title that you want to show.', 'antilia' ),
			'required' => array( 'show_404_bottom_section', '=', true ),
		),
		array(
			'id'    => '404_marquee_title3',
			'type'  => 'text',
			'title' => esc_html__( '404 Page Marquee Title', 'antilia' ),
			'desc'  => esc_html__( 'Enter 404 page marquee title that you want to show.', 'antilia' ),
			'required' => array( 'show_404_bottom_section', '=', true ),
		),
		array(
			'id'    => '404_marquee_title4',
			'type'  => 'text',
			'title' => esc_html__( '404 Page Marquee Title', 'antilia' ),
			'desc'  => esc_html__( 'Enter 404 page marquee title that you want to show.', 'antilia' ),
			'required' => array( 'show_404_bottom_section', '=', true ),
		),
		
		array(
			'id'     => '404_post_settings_end',
			'type'   => 'section',
			'indent' => false,
		),
	),
);