<?php
$styles = [];
foreach(range(1, 28) as $val) {
    $styles[$val] = sprintf(esc_html__('Style %s', 'antilia'), $val);
}

return  array(
    'title'      => esc_html__( 'Color Scheme Setting', 'antilia' ),
    'id'         => 'color_scheme_setting',
    'desc'       => '',
    'fields'     => array(
        
		array(
            'id' => 'color_scheme_loader',
            'type' => 'switch',
            'title' => esc_html__('Enable Color Scheme', 'antilia'),
            'default' => false,
        ),
		array(
			'id'       => 'main_color_scheme',
			'type'     => 'color',
			'title'    => esc_html__( 'Main Custom Color Scheme', 'antilia' ),
			'subtitle' => esc_html__( 'Choose the Custom color scheme for the theme', 'antilia' ),
			'required' => array( 'color_scheme_loader', '=', true ),
		),
		array(
			'id'       => 'secondary_color_scheme',
			'type'     => 'color',
			'title'    => esc_html__( 'Secondary Custom Color Scheme', 'antilia' ),
			'subtitle' => esc_html__( 'Choose the Custom color scheme for the theme', 'antilia' ),
			'required' => array( 'color_scheme_loader', '=', true ),
		),
	),
);
