<?php

return array(
	'title'      => esc_html__( 'Footer Setting', 'antilia' ),
	'id'         => 'footer_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'footer_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Footer Source Type', 'antilia' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'antilia' ),
				'e' => esc_html__( 'Elementor', 'antilia' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'footer_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'antilia' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'footer_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'footer_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Settings', 'antilia' ),
			'required' => array( 'footer_source_type', '=', 'd' ),
		),
		array(
		    'id'       => 'footer_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Footer Styles', 'antilia' ),
		    'subtitle' => esc_html__( 'Choose Footer Styles', 'antilia' ),
		    'options'  => array(

			    'footer_v1'  => array(
				    'alt' => esc_html__( 'Footer Style 1', 'antilia' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer_v1.png',
			    ),
				'footer_v2'  => array(
				    'alt' => esc_html__( 'Footer Style 2', 'antilia' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer_v2.png',
			    ),
				'footer_v3'  => array(
				    'alt' => esc_html__( 'Footer Style 3', 'antilia' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer_v3.png',
			    ),
			),
			'required' => array( 'footer_source_type', '=', 'd' ),
			'default' => 'footer_v1',
	    ),
		
		
		/***********************************************************************
								Footer Version 1 Start
		************************************************************************/
		array(
			'id'       => 'footer_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style One Settings', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		//Shape Image
		array(
			'id'       => 'footer_shape_image',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Shape BG Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert footer shape bg image', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		//Logo Image
		array(
			'id'       => 'footer_logo_image',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Logo Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert footer logo image', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		//MailChimp Form
		array(
            'id' => 'show_footer_v1_newsletter_form',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable MailChimp Form', 'antilia'),
            'default' => false,
            'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
        ),
		array(
			'id'      => 'footer_v1_newsletter_url',
			'type'    => 'text',
			'title'   => __( 'MailChimp Form Url', 'antilia' ),
			'required' => array( 'show_footer_v1_newsletter_form', '=', true ),
		),
		//Copyright Text
		array(
			'id'      => 'footer_v1_copyright_text',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		//Social Media Icons
		array(
            'id' => 'show_footer_v1_social_media',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Social Media Icons', 'antilia'),
            'default' => false,
            'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
        ),
		/***********************************************************************
								Footer Version 2 Start
		************************************************************************/
		array(
			'id'       => 'footer_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Two Settings', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		//Shape Image
		array(
			'id'       => 'footer_shape_image_v2',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Shape BG Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert footer shape bg image', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		//MailChimp Form
		array(
            'id' => 'show_footer_v2_newsletter_form',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable MailChimp Form', 'antilia'),
            'default' => false,
            'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
        ),
		array(
			'id'      => 'footer_v2_newsletter_title',
			'type'    => 'text',
			'title'   => __( 'MailChimp Form Title', 'antilia' ),
			'required' => array( 'show_footer_v2_newsletter_form', '=', true ),
		),
		array(
			'id'      => 'footer_v2_newsletter_url',
			'type'    => 'text',
			'title'   => __( 'MailChimp Form Url', 'antilia' ),
			'required' => array( 'show_footer_v2_newsletter_form', '=', true ),
		),
		
		//Copyright Text
		array(
			'id'      => 'footer_v2_copyright_text',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		//Social Media Icons
		array(
            'id' => 'show_footer_v2_social_media',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Social Media Icons', 'antilia'),
            'default' => false,
            'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
        ),
		
		/***********************************************************************
								Footer Version 3 Start
		************************************************************************/
		array(
			'id'       => 'footer_v3_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Three Settings', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		//Shape Image
		array(
			'id'       => 'footer_shape_image6',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Shape Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert footer shape image', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		//Logo Image
		array(
			'id'       => 'footer_logo_image_v3',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Logo Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert footer logo image', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),		
		//Copyright Text
		array(
			'id'      => 'footer_v3_copyright_text',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'antilia' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),	
		//Social Media Icons
		array(
            'id' => 'show_footer_v3_social_media',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Social Media Icons', 'antilia'),
            'default' => false,
            'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
        ),
		
		array(
			'id'       => 'footer_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'footer_source_type', '=', 'd' ],
		),
	),
);
