<?php
$styles = [];
foreach(range(1, 28) as $val) {
    $styles[$val] = sprintf(esc_html__('Style %s', 'antilia'), $val);
}

return  array(
    'title'      => esc_html__( 'Header Sidebar Setting', 'antilia' ),
    'id'         => 'header_sidebar_setting',
    'desc'       => '',
    'icon'       => 'el el-wrench',
    'fields'     => array(
       array(
            'id' => 'show_sidebar_info_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable Header Sidebar Info', 'antilia'),
            'default' => false,
        ),
		//Sidebar Title
		array(
			'id'      => 'header_sidebar_title_v1',
			'type'    => 'text',
			'title'   => __( 'Sidebar Title', 'antilia' ),
			'required' => array( 'show_sidebar_info_v1', '=', true ),
		),
		//Sidebar Description
		array(
			'id'      => 'header_sidebar_text_v1',
			'type'    => 'textarea',
			'title'   => __( 'Sidebar Description', 'antilia' ),
			'required' => array( 'show_sidebar_info_v1', '=', true ),
		),
		//Sidebar Info Title
		array(
			'id'      => 'header_sidebar_contact_title_v1',
			'type'    => 'text',
			'title'   => __( 'Contact Info Title', 'antilia' ),
			'required' => array( 'show_sidebar_info_v1', '=', true ),
		),
		//Address
		array(
            'id' => 'show_header_address2_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable Sidebar Address', 'antilia'),
            'default' => false,
			'required' => array( 'show_sidebar_info_v1', '=', true ),
        ),
		array(
			'id'      => 'header_address2_v1',
			'type'    => 'textarea',
			'title'   => __( 'Address', 'antilia' ),
			'required' => array( 'show_header_address2_v1', '=', true ),
		),
		//Email Address
		array(
            'id' => 'show_email2_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable Sidebar Email Address', 'antilia'),
            'default' => false,
			'required' => array( 'show_sidebar_info_v1', '=', true ),
        ),
		array(
			'id'      => 'sidebar_email_v1',
			'type'    => 'text',
			'title'   => __( 'Email Address', 'antilia' ),
			'required' => array( 'show_email2_v1', '=', true ),
		),
		//Phone Number
		array(
            'id' => 'show_phone_no2_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable Sidebar Phone Number', 'antilia'),
            'default' => false,
			'required' => array( 'show_sidebar_info_v1', '=', true ),
        ),
		array(
			'id'      => 'phone_number2',
			'type'    => 'text',
			'title'   => __( 'Phone Number', 'antilia' ),
			'required' => array( 'show_phone_no2_v1', '=', true ),
		),	
		//Working Timing
		array(
            'id' => 'show_whour_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable Sidebar Working Timing', 'antilia'),
            'default' => false,
			'required' => array( 'show_sidebar_info_v1', '=', true ),
        ),
		array(
			'id'      => 'sidebar_working_hours',
			'type'    => 'text',
			'title'   => __( 'Working Timing', 'antilia' ),
			'required' => array( 'show_whour_v1', '=', true ),
		),
		//Newsletter Form Info
		array(
            'id' => 'show_newsletter_section',
            'type' => 'switch',
            'title' => esc_html__('Enable Sidebar MailChimp Form Info', 'antilia'),
            'default' => false,
			'required' => array( 'show_sidebar_info_v1', '=', true ),
        ),
		array(
			'id'      => 'sidebar_newsletter_title_v1',
			'type'    => 'text',
			'title'   => __( 'MailChimp Form Title', 'antilia' ),
			'required' => array( 'show_newsletter_section', '=', true ),
		),	
		array(
			'id'      => 'sidebar_newsletter_url_v1',
			'type'    => 'text',
			'title'   => __( 'MailChimp Form Url', 'antilia' ),
			'required' => array( 'show_newsletter_section', '=', true ),
		),	
    ),
);

