<?php
return array(
	'title'      => esc_html__( 'Header Setting', 'antilia' ),
	'id'         => 'headers_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'header_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Header Source Type', 'antilia' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'antilia' ),
				'e' => esc_html__( 'Elementor', 'antilia' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'header_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'antilia' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'header_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'header_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Settings', 'antilia' ),
			'required' => array( 'header_source_type', '=', 'd' ),
		),

		//Header Settings
		array(
		    'id'       => 'header_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Header Styles', 'antilia' ),
		    'subtitle' => esc_html__( 'Choose Header Styles', 'antilia' ),
		    'options'  => array(

			    'header_v1'  => array(
				    'alt' => esc_html__( 'Header Style 1', 'antilia' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v1.png',
			    ),
			    'header_v2'  => array(
				    'alt' => esc_html__( 'Header Style 2', 'antilia' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header_v2.png',
			    ),
			),
			'required' => array( 'header_source_type', '=', 'd' ),
			'default' => 'header_v1',
	    ),

		/***********************************************************************
								Header Version 1 Start
		************************************************************************/
		array(
			'id'       => 'header_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style One Settings', 'antilia' ),
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
		),
		//Topheader Info
		array(
            'id' => 'show_topbar_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Top Header Info', 'antilia'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		//Welcome Text
		array(
            'id' => 'show_welcome_text_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Welcome Info', 'antilia'),
            'default' => false,
            'required' => array( 'show_topbar_v1', '=', true ),
        ),
		array(
			'id'      => 'welcome_text_v1',
			'type'    => 'text',
			'title'   => __( 'Welcome Title', 'antilia' ),
			'required' => array( 'show_welcome_text_v1', '=', true ),
		),	
		//Phone Number
		array(
            'id' => 'show_phone_no_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Phone Info', 'antilia'),
            'default' => false,
            'required' => array( 'show_topbar_v1', '=', true ),
        ),
		array(
			'id'      => 'phone_number_v1',
			'type'    => 'text',
			'title'   => __( 'Phone Number', 'antilia' ),
			'required' => array( 'show_phone_no_v1', '=', true ),
		),
		//Social Media
		array(
            'id' => 'show_social_media_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Social Media Info', 'antilia'),
            'default' => false,
            'required' => array( 'show_topbar_v1', '=', true ),
        ),
		array(
			'id'      => 'social_icon_title_v1',
			'type'    => 'text',
			'title'   => __( 'Social Media Title', 'antilia' ),
			'required' => array( 'show_social_media_v1', '=', true ),
		),
		//Search Icon
		array(
            'id' => 'show_search_icon_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Search Icon', 'antilia'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),		
		//Cart Icon
		array(
            'id' => 'show_cart_icon_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Cart Icon', 'antilia'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		array(
			'id'      => 'cart_title_v1',
			'type'    => 'text',
			'title'   => __( 'Cart Title', 'antilia' ),
			'required' => array( 'show_cart_icon_v1', '=', true ),
		),
		array(
			'id'      => 'cart_offer_v1',
			'type'    => 'text',
			'title'   => __( 'Cart Offer Title', 'antilia' ),
			'required' => array( 'show_cart_icon_v1', '=', true ),
		),
		array(
			'id'      => 'cart_popular_title_v1',
			'type'    => 'text',
			'title'   => __( 'Cart Popular Items Title', 'antilia' ),
			'required' => array( 'show_cart_icon_v1', '=', true ),
		),
		//Get A Quote Button Info
		array(
            'id' => 'show_btn_info_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Button Info', 'antilia'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		array(
			'id'      => 'btn_title_v1',
			'type'    => 'text',
			'title'   => __( 'Button Title', 'antilia' ),
			'required' => array( 'show_btn_info_v1', '=', true ),
		),
		array(
			'id'      => 'btn_link_v1',
			'type'    => 'text',
			'title'   => __( 'Button Link', 'antilia' ),
			'required' => array( 'show_btn_info_v1', '=', true ),
		),
		
		/***********************************************************************
								Header Version 2 Start
		************************************************************************/
		array(
			'id'       => 'header_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Two Settings', 'antilia' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		//Topheader Info
		array(
            'id' => 'show_topbar_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Top Header Info', 'antilia'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		//Welcome Text
		array(
            'id' => 'show_welcome_text_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Welcome Info', 'antilia'),
            'default' => false,
            'required' => array( 'show_topbar_v2', '=', true ),
        ),
		array(
			'id'      => 'welcome_text_v2',
			'type'    => 'text',
			'title'   => __( 'Welcome Title', 'antilia' ),
			'required' => array( 'show_welcome_text_v2', '=', true ),
		),	
		//Phone Number
		array(
            'id' => 'show_phone_no_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Phone Info', 'antilia'),
            'default' => false,
            'required' => array( 'show_topbar_v2', '=', true ),
        ),
		array(
			'id'      => 'phone_number_v2',
			'type'    => 'text',
			'title'   => __( 'Phone Number', 'antilia' ),
			'required' => array( 'show_phone_no_v2', '=', true ),
		),
		//Social Media
		array(
            'id' => 'show_social_media_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Social Media Info', 'antilia'),
            'default' => false,
            'required' => array( 'show_topbar_v2', '=', true ),
        ),
		array(
			'id'      => 'social_icon_title_v2',
			'type'    => 'text',
			'title'   => __( 'Social Media Title', 'antilia' ),
			'required' => array( 'show_social_media_v2', '=', true ),
		),
		//Search Icon
		array(
            'id' => 'show_search_icon_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Search Icon', 'antilia'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),		
		//Cart Icon
		array(
            'id' => 'show_cart_icon_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Cart Icon', 'antilia'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
			'id'      => 'cart_title_v2',
			'type'    => 'text',
			'title'   => __( 'Cart Title', 'antilia' ),
			'required' => array( 'show_cart_icon_v2', '=', true ),
		),
		array(
			'id'      => 'cart_offer_v2',
			'type'    => 'text',
			'title'   => __( 'Cart Offer Title', 'antilia' ),
			'required' => array( 'show_cart_icon_v2', '=', true ),
		),
		array(
			'id'      => 'cart_popular_title_v2',
			'type'    => 'text',
			'title'   => __( 'Cart Popular Items Title', 'antilia' ),
			'required' => array( 'show_cart_icon_v2', '=', true ),
		),
		//Get A Quote Button Info
		array(
            'id' => 'show_btn_info_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Button Info', 'antilia'),
            'default' => false,
            'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
			'id'      => 'btn_title_v2',
			'type'    => 'text',
			'title'   => __( 'Button Title', 'antilia' ),
			'required' => array( 'show_btn_info_v2', '=', true ),
		),
		array(
			'id'      => 'btn_link_v2',
			'type'    => 'text',
			'title'   => __( 'Button Link', 'antilia' ),
			'required' => array( 'show_btn_info_v2', '=', true ),
		),
										
		array(
			'id'       => 'header_style_section_end',
			'type'     => 'section',
			'indent'      => false,
			'required' => [ 'header_source_type', '=', 'd' ],
		),
	),
);
