<?php
return array(
	'title'      => esc_html__( 'Logo Setting', 'antilia' ),
	'id'         => 'logo_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'       => 'image_favicon',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Favicon', 'antilia' ),
			'subtitle' => esc_html__( 'Insert site favicon image', 'antilia' ),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/favicon.png' ),
		),
		//Light Logo
		array(
            'id' => 'normal_logo_show',
            'type' => 'switch',
            'title' => esc_html__('Enable Header Light Color Logo', 'antilia'),
            'default' => true,
        ),
		array(
			'id'       => 'light_color_logo',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Header Light Logo Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert site Header Light logo image', 'antilia' ),
			'required' => array( 'normal_logo_show', '=', true ),
		),
		array(
			'id'       => 'light_color_logo_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'Header Light Logo Dimentions', 'antilia' ),
			'subtitle' => esc_html__( 'Select Header Light Logo Dimentions', 'antilia' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'normal_logo_show', '=', true ),
		),
		
		//Small Light Logo
		array(
            'id' => 'small_logo_show',
            'type' => 'switch',
            'title' => esc_html__('Enable Header Sticky Light Color Logo', 'antilia'),
            'default' => true,
        ),
		array(
			'id'       => 'small_light_color_logo',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Sticky Header Light Logo Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert site Sticky Header Light logo image', 'antilia' ),			
			'required' => array( 'small_logo_show', '=', true ),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/logo-2.png' ),
		),
		array(
			'id'       => 'small_light_color_logo_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'Sticky Header Light Logo Dimentions', 'antilia' ),
			'subtitle' => esc_html__( 'Select Sticky Header Light Logo Dimentions', 'antilia' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'small_logo_show', '=', true ),
		),
		
		//Dark Logo
		array(
            'id' => 'dark_logo_show',
            'type' => 'switch',
            'title' => esc_html__('Enable Header Dark Color Logo', 'antilia'),
            'default' => true,
        ),
		array(
			'id'       => 'dark_color_logo',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Header Dark Logo Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert site Header Dark logo image', 'antilia' ),
			'required' => array( 'dark_logo_show', '=', true ),
		),
		array(
			'id'       => 'dark_color_logo_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'Header Dark Logo Dimentions', 'antilia' ),
			'subtitle' => esc_html__( 'Select Header Dark Logo Dimentions', 'antilia' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'dark_logo_show', '=', true ),
		),
		
		//Small Dark Logo
		array(
            'id' => 'small_dark_logo_show',
            'type' => 'switch',
            'title' => esc_html__('Enable Header Sticky Dark Color Logo', 'antilia'),
            'default' => true,
        ),
		array(
			'id'       => 'small_dark_color_logo',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Sticky Header Dark Logo Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert site Sticky Header Dark logo image', 'antilia' ),
			'required' => array( 'small_dark_logo_show', '=', true ),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/logo-2.png' ),
		),
		array(
			'id'       => 'small_dark_color_logo_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'Sticky Header Dark Logo Dimentions', 'antilia' ),
			'subtitle' => esc_html__( 'Select Sticky Header Dark Logo Dimentions', 'antilia' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'small_dark_logo_show', '=', true ),
		),
		
		//Mobile Color Logo
		array(
            'id' => 'mobile_logo_show2',
            'type' => 'switch',
            'title' => esc_html__('Enable Header Mobile Color Logo Image', 'antilia'),
            'default' => true,
        ),
		array(
			'id'       => 'mobile_color_logo',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Mobile Logo Image', 'antilia' ),
			'subtitle' => esc_html__( 'Insert site Mobile Logo Image', 'antilia' ),
			'required' => array( 'mobile_logo_show2', '=', true ),
		),
		array(
			'id'       => 'mobile_color_logo_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'Mobile Logo Image Dimentions', 'antilia' ),
			'subtitle' => esc_html__( 'Select Mobile Logo Image Dimentions', 'antilia' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'mobile_logo_show2', '=', true ),
		),
			
				
		array(
			'id'       => 'logo_settings_section_end',
			'type'     => 'section',
			'indent'      => false,
		),
	),
);
