<?php
/**
 * Default Template Main File.
 *
 * @package ANTILIA
 * @author  Codeliono
 * @version 1.0
 */

get_header();
$data  = \ANTILIA\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-lg-12 col-sm-12 col-md-12' : 'col-lg-9 col-md-12 col-sm-12';
?>

<?php if ( $data->get( 'enable_banner' ) ) : ?>
	<?php do_action( 'antilia_banner', $data );?>
<?php else:?>
<!-- Page Title -->
<section class="page-title" <?php if($data->get( 'banner' )){ ?> style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')"<?php } ?>>
    <div class="auto-container">
        <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( the_title( ) ); ?></h2>
        <?php if(antilia_the_breadcrumb()){ ?>
        <ul class="bread-crumb clearfix">
            <?php echo antilia_the_breadcrumb(); ?>
        </ul>
        <?php } ?>
    </div>
</section>
<!-- End Page Title -->
<?php endif;?>

<!-- sidebar-page-container -->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">	
        	
			<?php if( $data->get( 'layout' ) == 'left' ): ?>
			<!-- Sidebar Side -->
            <div class="sidebar-side col-lg-3 col-md-12 col-sm-12">
                <aside class="sidebar sticky-top">
                    <?php dynamic_sidebar( $sidebar ); ?>
                </aside>
            </div>
			<?php endif; ?>
            
            <div class="content-side <?php echo esc_attr( $class ); ?> <?php if ( $data->get( 'layout' ) == 'left' ) echo 'left-sidebar'; elseif ( $data->get( 'layout' ) == 'right' ) echo 'right-sidebar'; ?>">
                <div class="blog-classic">
                    <div class="thm-unit-test">
                            
                        <?php while ( have_posts() ): the_post(); ?>
                            <?php the_content(); ?>
                        <?php endwhile; ?>
                        
                        <div class="clearfix"></div>
                        <?php
                        $defaults = array(
                            'before' => '<div class="paginate-links">' . esc_html__( 'Pages:', 'antilia' ),
                            'after'  => '</div>',
        
                        );
                        wp_link_pages( $defaults );
                        ?>
                        <?php comments_template() ?>
                     
                     </div>
                     
                </div>
            </div>
			<?php if( $data->get( 'layout' ) == 'right' ): ?>
			<!-- Sidebar Side -->
            <div class="sidebar-side col-lg-3 col-md-12 col-sm-12">
                <aside class="sidebar sticky-top">
                    <?php dynamic_sidebar( $sidebar ); ?>
                </aside>
            </div>
			<?php endif; ?>
        
        </div>
	</div>
</div><!-- blog section with pagination -->
<?php get_footer(); ?>
