<?php get_header();
	$data = \ANTILIA\Includes\Classes\Common::instance()->data('single-project')->get();
	
?>
<!-- Page Title -->
<section class="page-title" <?php if($data->get( 'banner' )){ ?> style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')"<?php } ?>>
    <div class="auto-container">
        <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( the_title( ) ); ?></h2>
        <?php if(antilia_the_breadcrumb()){ ?>
        <ul class="bread-crumb clearfix">
            <?php echo antilia_the_breadcrumb(); ?>
        </ul>
        <?php } ?>
    </div>
</section>
<!-- End Page Title -->

<?php 
	while (have_posts()) : the_post(); 
?>
<!-- Project Detail -->
<section class="project-detail">
    <div class="auto-container">
    	<div class="upper-box">
            <?php if(get_post_meta( get_the_id(), 'project_categories', true )) {?><div class="project-detail_title"><?php echo (get_post_meta( get_the_id(), 'project_categories', true ));?></div><?php } ?>
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <div class="project-detail-author">
                    <?php $project_author_image = get_post_meta( get_the_id(), 'project_author_image', true ); ?>
					<?php if($project_author_image['id']){ ?>
                    <div class="project-detail-author_image">
                        <img src="<?php echo wp_get_attachment_url($project_author_image['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" />
                    </div>
                    <?php } ?>
                    <?php echo (get_post_meta( get_the_id(), 'project_author_by', true ));?>
                    <strong><?php echo (get_post_meta( get_the_id(), 'project_author_name', true ));?></strong>
                </div>
                <?php
					$icons = get_post_meta(get_the_id(), 'project_social_media_tabs', true); if ($icons) : 
				?>
                <!-- Social Box -->
                <div class="project-detail_socials">
                    <?php
						for ( $i=0; $i < count( $icons['select_social_media2'] ); $i++ ) {
						$social_icon2 = ( isset( $icons['select_social_media2'][$i] ) && !empty( $icons['select_social_media2'][$i] ) ) ? $icons['select_social_media2'][$i] : '';
						$social_link2 = ( isset( $icons['link_social_media2'][$i] ) && !empty( $icons['link_social_media2'][$i] ) ) ? $icons['link_social_media2'][$i] : '';
					?>
                    <a href="<?php echo esc_url($social_link2); ?>"><i class="fab <?php echo esc_attr(str_replace("fa ", " ", $social_icon2)); ?>"></i></a>
                    <?php } ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="project-detail_image">
            <?php $project_feature_image = get_post_meta( get_the_id(), 'project_feature_image', true ); ?>
            <?php if($project_feature_image['id']){ ?><img src="<?php echo wp_get_attachment_url($project_feature_image['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" /><?php } ?>
            <?php
				$icons = get_post_meta(get_the_id(), 'info_tabs', true); if ($icons) : 
			?>
            <div class="content">
                <ul>
                    <?php 
						for ( $i=0; $i < count( $icons['pinfo_title'] ); $i++ ) {
						$pinfo_title = ( isset( $icons['pinfo_title'][$i] ) && !empty( $icons['pinfo_title'][$i] ) ) ? $icons['pinfo_title'][$i] : '';
						$pinfo_text = ( isset( $icons['pinfo_text'][$i] ) && !empty( $icons['pinfo_text'][$i] ) ) ? $icons['pinfo_text'][$i] : '';
					?>
                    <li><span><?php echo esc_attr($pinfo_title); ?></span><?php echo esc_attr($pinfo_text); ?></li>
                    <?php } ?>
                </ul>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="middle-box">
        	<?php the_content(); ?>
        </div>
        <div class="project-detail_gallery">
            <div class="row clearfix">
                <?php $project_feature_image2 = get_post_meta( get_the_id(), 'project_feature_image2', true ); ?>
                <?php if($project_feature_image2['id']){ ?>
                <!-- Project Detail Gallery Image -->
                <div class="project-detail_gallery-image skewElem col-lg-12 col-md-12 col-sm-12">
                    <img src="<?php echo wp_get_attachment_url($project_feature_image2['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" />
                </div>
                <?php } ?>
                <?php $project_feature_image3 = get_post_meta( get_the_id(), 'project_feature_image3', true ); ?>
                <?php if($project_feature_image3['id']){ ?>
                <!-- Project Detail Gallery Image -->
                <div class="project-detail_gallery-image skewElem col-lg-6 col-md-6 col-sm-6">
                    <img src="<?php echo wp_get_attachment_url($project_feature_image3['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" />
                </div>
                <?php } ?>
                <?php $project_feature_image4 = get_post_meta( get_the_id(), 'project_feature_image4', true ); ?>
                <?php if($project_feature_image4['id']){ ?>
                <!-- Project Detail Gallery Image -->
                <div class="project-detail_gallery-image skewElem col-lg-6 col-md-6 col-sm-6">
                    <img src="<?php echo wp_get_attachment_url($project_feature_image4['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" />
                </div>
                <?php } ?>
                <?php $project_feature_image5 = get_post_meta( get_the_id(), 'project_feature_image5', true ); ?>
                <?php if($project_feature_image5['id']){ ?>
                <!-- Project Detail Gallery Image -->
                <div class="project-detail_gallery-image skewElem col-lg-12 col-md-12 col-sm-12">
                    <img src="<?php echo wp_get_attachment_url($project_feature_image5['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" />
                </div>
                <?php } ?>
            </div>
        </div>        
		<?php if((get_previous_post()) || (get_next_post())): ?>    
        <div class="project-detail_new-posts">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <?php global $post; $prev_post = get_previous_post();
					if (!empty($prev_post)):
				?>
                <a href="<?php echo esc_url(get_the_permalink($prev_post->ID)); ?>"><span><img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/icons/client-one_prev-arrow.png" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" /></span> <?php echo wp_kses_post($prev_post->post_title); ?></a>
                <?php endif; ?>                
                <?php global $post; $next_post = get_next_post();
                    if (!empty($next_post)):
                ?>
                <a href="<?php echo esc_url(get_the_permalink($next_post->ID)); ?>"><?php echo wp_kses_post($next_post->post_title); ?> <span><img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/icons/client-one_next-arrow.png" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" /></span></a>
            	<?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</section>
<!-- End Project Detail -->

<?php endwhile; ?>
<?php get_footer(); ?>