<?php get_header();
	$data = \ANTILIA\Includes\Classes\Common::instance()->data('single-service')->get();
	
?>
<!-- Page Title -->
<section class="page-title" <?php if($data->get( 'banner' )){ ?> style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')"<?php } ?>>
    <div class="auto-container">
        <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( the_title( ) ); ?></h2>
        <?php if(antilia_the_breadcrumb()){ ?>
        <ul class="bread-crumb clearfix">
            <?php echo antilia_the_breadcrumb(); ?>
        </ul>
        <?php } ?>
    </div>
</section>
<!-- End Page Title -->

<?php 
	while (have_posts()) : the_post(); 
?>
<!-- Service Detail -->
<section class="service-detail">
    <div class="auto-container">
        <div class="inner-container">
            <div class="service-detail_color-circle"></div>
            <div class="row clearfix">
                <!-- Content Column -->
                <div class="service-detail_content-column col-lg-7 col-md-12 col-sm-12">
                    <div class="service-detail_content">
                        <!-- Feature Block -->
                        <div class="feature-block">
                            <div class="feature-block_inner">
                                <?php $service_icon_image = get_post_meta( get_the_id(), 'service_icon_image', true ); ?>
                                <?php if($service_icon_image['id']){ ?>
                                <div class="feature-block_icon">
                                    <img src="<?php echo wp_get_attachment_url($service_icon_image['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" />
                                </div>
                                <?php } ?>
                                <h3><?php the_title(); ?></h3>
                                <p><?php echo (get_post_meta( get_the_id(), 'service_top_description', true ));?></p>
                            </div>
                        </div>
						<?php $service_image = get_post_meta( get_the_id(), 'service_feature_image', true ); ?>
                        <?php if($service_image['id']){ ?>
                        <div class="service-detail_image  skewElem">
                            <img src="<?php echo wp_get_attachment_url($service_image['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" />
                        </div>
						<?php } ?>
                    </div>
                </div>
				<?php $service_image2 = get_post_meta( get_the_id(), 'service_feature_image2', true ); ?>
                <?php if($service_image2['id']){ ?>
                <!-- Image Column -->
                <div class="service-detail_image-column col-lg-5 col-md-10 col-sm-12">
                    <div class="service-detail_image-two  skewElem">
                        <img src="<?php echo wp_get_attachment_url($service_image2['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" />
                    </div>
                </div>
				<?php } ?>
            </div>
            
			<?php the_content(); ?>
            
            <div class="service-detail_video">
                <?php $service_image3 = get_post_meta( get_the_id(), 'service_feature_image3', true ); ?>
                <?php if($service_image3['id']){ ?>
                <img src="<?php echo wp_get_attachment_url($service_image3['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'antilia'); ?>" />
                <?php } ?>
                <?php if(get_post_meta( get_the_id(), 'service_video_url', true )){ ?>
                <a href="<?php echo esc_url(get_post_meta( get_the_id(), 'service_video_url', true ));?>" class="lightbox-video services-one_play"><span class="fa fa-play"><i class="ripple"></i></span></a>
            	<?php } ?>
            </div>
            
            <?php if(get_post_meta( get_the_id(), 'service_faqs_title', true )){ ?><h3><?php echo (get_post_meta( get_the_id(), 'service_faqs_title', true ));?></h3><?php } ?>
            <?php if(get_post_meta( get_the_id(), 'service_bottom_description', true )){ ?><p><?php echo (get_post_meta( get_the_id(), 'service_bottom_description', true ));?></p><?php } ?>
			<?php
				$icons = get_post_meta(get_the_id(), 'service_info_tabs', true); if ($icons) : 
			?>
            <!-- Accordion Box -->
            <ul class="accordion-box">
                <?php 
					$count = 1;
					for ( $i=0; $i < count( $icons['info_title2'] ); $i++ ) {
					$info_title2 = ( isset( $icons['info_title2'][$i] ) && !empty( $icons['info_title2'][$i] ) ) ? $icons['info_title2'][$i] : '';
					$info_text2 = ( isset( $icons['info_text2'][$i] ) && !empty( $icons['info_text2'][$i] ) ) ? $icons['info_text2'][$i] : '';
				?>
                <!-- Block -->
                <li class="accordion block <?php if($count == '1') echo 'active-block';?>">
                    <div class="acc-btn <?php if($count == '1') echo 'active';?>"><div class="icon-outer"><span class="icon plus fa fa-plus"></span> <span class="icon minus fa fa-minus"></span></div><?php echo esc_attr($info_title2); ?></div>
                    <div class="acc-content <?php if($count == '1') echo 'current';?>">
                        <div class="content">
                            <div class="text"><?php echo esc_attr($info_text2); ?></div>
                        </div>
                    </div>
                </li>
                <?php $count++; } ?>
            </ul>
            <?php endif; ?>            
        </div>        
    </div>
</section>
<!-- End Service Detail -->

<?php endwhile; ?>
<?php get_footer(); ?>