<?php get_header();
	$data = \ANTILIA\Includes\Classes\Common::instance()->data('single-team')->get(); 

?>

<!-- Page Title -->
<section class="page-title" <?php if($data->get( 'banner' )){ ?> style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')"<?php } ?>>
    <div class="auto-container">
        <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( the_title( ) ); ?></h2>
        <?php if(antilia_the_breadcrumb()){ ?>
        <ul class="bread-crumb clearfix">
            <?php echo antilia_the_breadcrumb(); ?>
        </ul>
        <?php } ?>
    </div>
</section>
<!-- End Page Title -->

<?php while (have_posts()) : the_post(); ?>

<!--
=====================================================
    Team Details
=====================================================
-->
<!-- Team Detail -->
<section class="team-detail">
    <div class="auto-container">
        <div class="row clearfix">
            <!-- Info Column -->
            <div class="team-detail_info-column col-lg-3 col-md-12 col-sm-12">
                <div class="team-detail_info-inner">
                    <?php if(has_post_thumbnail()):?>
                    <div class="team-detail_author">
                        <?php the_post_thumbnail('antilia_275x310'); ?>
                    </div>
                    <?php endif; ?>
                    <ul class="team-detail_author-info">
                        <?php if(get_post_meta( get_the_id(), 'designation_title', true ) || get_post_meta( get_the_id(), 'designation', true )){ ?>
                        <li><span><?php echo (get_post_meta( get_the_id(), 'designation_title', true ));?> </span> <?php echo (get_post_meta( get_the_id(), 'designation', true ));?></li>
                        <?php } ?>
                        <?php if(get_post_meta( get_the_id(), 'email_title', true ) || get_post_meta( get_the_id(), 'team_email', true )){ ?>
                        <li><span><?php echo (get_post_meta( get_the_id(), 'email_title', true ));?> </span> <a href="mailto:<?php echo (get_post_meta( get_the_id(), 'team_email', true ));?>"><?php echo (get_post_meta( get_the_id(), 'team_email', true ));?></a></li>
                        <?php } ?>
                        <?php if(get_post_meta( get_the_id(), 'phone_no_title', true ) || get_post_meta( get_the_id(), 'team_phone_no', true )){ ?>
                        <li><span><?php echo (get_post_meta( get_the_id(), 'phone_no_title', true ));?> </span> <a href="tel:<?php echo (get_post_meta( get_the_id(), 'team_phone_no', true ));?>"><?php echo (get_post_meta( get_the_id(), 'team_phone_no', true ));?></a></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
            <!-- Content Column -->
            <div class="team-detail_content-column col-lg-9 col-md-12 col-sm-12">
                <div class="team-detail_content-inner">
                    <?php the_content();?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Team Detail -->

<?php endwhile; ?>

<?php get_footer(); ?>