<?php
/**
 * Blog Post Main File.
 *
 * @package ANTILIA
 * @author  Codeliono
 * @version 1.0
 */

get_header();
$options = antilia_WSH()->option();

$data    = \ANTILIA\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-lg-12 col-sm-12 col-md-12' : 'col-lg-9 col-md-12 col-sm-12';

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else {
?>

<!-- Page Title -->
<section class="page-title" <?php if($data->get( 'banner' )){ ?> style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')"<?php } ?>>
    <div class="auto-container">
        <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( the_title( ) ); ?></h2>
        <?php if(antilia_the_breadcrumb()){ ?>
        <ul class="bread-crumb clearfix">
            <?php echo antilia_the_breadcrumb(); ?>
        </ul>
        <?php } ?>
    </div>
</section>
<!-- End Page Title -->

<?php while ( have_posts() ) : the_post(); ?>

<!-- sidebar-page-container -->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">   	
        	
			<?php if( $data->get( 'layout' ) == 'left' ): ?>
			<!-- Sidebar Side -->
            <div class="sidebar-side col-lg-3 col-md-12 col-sm-12">
                <aside class="sidebar sticky-top">
                    <?php dynamic_sidebar( $sidebar ); ?>
                </aside>
            </div>
			<?php endif; ?>
            
            <div class="content-side <?php echo esc_attr( $class ); ?> <?php if ( $data->get( 'layout' ) == 'left' ) echo 'left-sidebar'; elseif ( $data->get( 'layout' ) == 'right' ) echo 'right-sidebar'; ?>">				                               	
                <div class="thm-unit-test"> 
                	<!-- News Detail -->
					<div class="news-detail">
                    	<div class="inner-box">
                            <?php if(has_post_thumbnail()): ?>
                            <?php if( $options->get( 'single_post_author' ) ){ ?>
                            <!-- Post Info -->
                            <div class="post-info">
                                <div class="post-inner">
                                    <?php if($avatar = get_avatar(get_the_author_meta('ID')) !== FALSE): ?>
                                    <div class="post-image">
                                        <?php echo get_avatar(get_the_author_meta('ID'), 24); ?>
                                    </div>
                                    <?php endif; ?>
                                    <?php esc_html_e('By:', 'antilia'); ?> <span><?php the_author(); ?></span>
                                </div>
                            </div>
                            <?php } ?>
                            <div class="upper-image">
                                <?php the_post_thumbnail('antilia_1170x520'); ?>
                                <?php the_post_thumbnail('antilia_1170x520'); ?>
                            </div>
                            <?php endif; ?>
                            <div class="lower-content">
                                <?php if( $options->get( 'single_post_date' ) || $options->get( 'single_post_comments' ) ){ ?>
                                <ul class="post-meta">
                                    <?php if( $options->get( 'single_post_date' ) ){ ?><li><span class="icon fas fa-calendar-alt"></span><?php echo get_the_date( ); ?></li><?php } ?>
                                    <?php if( $options->get( 'single_post_comments' ) ){ ?>
                                    <li><span class="icon fas fa-comment-alt"></span><?php comments_number( wp_kses(__('Comments (0)' , 'antilia'), true), wp_kses(__('Comment (01)' , 'antilia'), true), wp_kses(__('Comments: (%)' , 'antilia'), true)); ?></li>
                                    <?php } ?>
                                </ul>
                                <?php } ?>
                        		
                                <div class="text-holder text"><?php the_content(); ?></div>
                                <div class="clearfix"></div>
                                <?php wp_link_pages(array('before'=>'<div class="paginate-links m-t30">'.esc_html__('Pages: ', 'antilia'), 'after' => '</div>', 'link_before'=>'<span>', 'link_after'=>'</span>')); ?>  
                        		<?php if(has_tag() || function_exists('bunch_share_us_two')):?>
                                <!-- Post Share Options-->
								<div class="post-share-options">
									<div class="post-share-inner d-flex justify-content-between align-items-center flex-wrap">
										<?php if(has_tag()):?>
                                        <div class="tags"><span><?php esc_html_e('Tags:', 'antilia'); ?></span><?php the_tags( '', '  ', '' ); ?></div>
                                        <?php endif;?>
										<?php if(function_exists('bunch_share_us_two')):?>                                        
                                        <ul class="social-box">
											<li class="antilia-share-title"><?php esc_html_e('Share:', 'antilia'); ?></li>
											<?php echo bunch_share_us_two(get_the_id(),$post->post_name );?>
										</ul>
                                        <?php endif;?>
									</div>
								</div>
                                <?php endif;?>
								<?php if( $options->get( 'single_post_author_box' ) ):?>
								<!-- Author Box -->
								<div class="blog-author-box">
									<div class="author-inner">
										<?php if($avatar = get_avatar(get_the_author_meta('ID')) !== FALSE): ?>
                                        <div class="thumb"><?php echo get_avatar(get_the_author_meta('ID'), 156); ?></div>
                                        <?php endif; ?>
										<div class="name"><?php esc_html_e('About', 'antilia'); ?> <?php the_author(); ?></div>
										<div class="text"><?php the_author_meta( 'description', get_the_author_meta('ID') ); ?></div>
										<?php if( $options->get( 'single_post_author_links' ) ):?>
                                        <ul class="social-box">
											<?php echo wp_kses($options->get('single_post_author_social_share'), true); ?>
										</ul>
                                        <?php endif; ?>
									</div>
								</div>
								<?php endif;?>
                                <?php if((get_previous_post()) || (get_next_post())): ?>
								<!-- Blog More Posts -->
								<div class="blog-more-posts">
									<div class="d-flex justify-content-between align-items-center">
										<?php global $post; $prev_post = get_previous_post();
											if (!empty($prev_post)):
										?>
                                        <a href="<?php echo esc_url(get_the_permalink($prev_post->ID)); ?>"><span class="fas fa-arrow-left fa-fw"></span> &nbsp; <?php esc_html_e('Previous Post', 'antilia'); ?></a>
										<?php endif ?>
										<?php global $post; $next_post = get_next_post();
                                            if (!empty($next_post)):
                                        ?>
                                        <a href="<?php echo esc_url(get_the_permalink($next_post->ID)); ?>"><?php esc_html_e('next Post', 'antilia'); ?> &nbsp; <span class="fas fa-arrow-right fa-fw"></span></a>
                                        <?php endif ?>
									</div>
								</div>
                                <?php endif;?>
                                
                                <!--End post-details-->
                        		<?php comments_template(); ?>
                                
                            </div>   
                   		</div>
                   </div>
                </div>
                <!--End thm-unit-test-->				
            </div>
        	
			<?php if( $data->get( 'layout' ) == 'right' ): ?>
            <!-- Sidebar Side -->
            <div class="sidebar-side col-lg-3 col-md-12 col-sm-12">
                <aside class="sidebar sticky-top">
                    <?php dynamic_sidebar( $sidebar ); ?>
                </aside>
            </div>
			<?php endif; ?>
            
        </div>
    </div>
</div>
<!--End blog area--> 
<?php endwhile; ?>

<?php
}
get_footer();
