<?php

/**
 * Blog Content Template
 *
 * @package    WordPress
 * @subpackage ANTILIA
 * @author     Codeliono
 * @version    1.0
 */

if (class_exists('Antilia_Resizer')) {
    $img_obj = new Antilia_Resizer();
} else {
    $img_obj = array();
}
$options = antilia_WSH()->option();
$allowed_tags = wp_kses_allowed_html('post');

?>


<div <?php post_class(); ?>>
	
    <!-- News Block One -->
    <div class="news-block_two">
        <div class="news-block_two-inner wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
            <?php if(has_post_thumbnail()){ ?>
            <div class="news-block_two-image">
                <a href="<?php echo esc_url( get_the_permalink( get_the_id() ) );?>"><?php the_post_thumbnail('antilia_1170x520'); ?></a>
                <a href="<?php echo esc_url( get_the_permalink( get_the_id() ) );?>" class="news-block_two-arrow fa fa-arrow-right fa-fw"></a>
            </div>
            <?php } ?>
            <div class="news-block_two-content">
                <div class="news-block_two-title"><?php the_category(' '); ?></div>
                <h4 class="news-block_two-heading"><a href="<?php echo esc_url( get_the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h4>
                <div class="news-block_two-text"><?php the_excerpt(); ?></div>
                <?php if( $options->get( 'blog_post_date' ) || $options->get( 'blog_post_comments' ) ){ ?>
                <ul class="news-block_two-meta">
                    <?php if( $options->get( 'blog_post_date' ) ){ ?> <li><span class="icon fas fa-calendar-alt"></span><?php echo get_the_date( ); ?></li><?php } ?>
                    <?php if( $options->get( 'blog_post_comments' ) ){ ?> <li><span class="icon fas fa-comment-alt"></span><?php comments_number( wp_kses(__('0 Comments' , 'antilia'), true), wp_kses(__('01 Comment' , 'antilia'), true), wp_kses(__('% Comments' , 'antilia'), true)); ?></li><?php } ?>
                </ul>
                <?php } ?>
            </div>
        </div>
    </div>
        
</div>