<?php
/**
 * Footer Template  File
 *
 * @package ANTILIA
 * @author  Codeliono
 * @version 1.0
 */

$options = antilia_WSH()->option();

$footer_shape_image = $options->get( 'footer_shape_image' );
$footer_shape_image = antilia_set( $footer_shape_image, 'url', ANTILIA_URI . '' );

$footer_logo_image = $options->get( 'footer_logo_image' );
$footer_logo_image = antilia_set( $footer_logo_image, 'url', ANTILIA_URI . '' );

$allowed_html = wp_kses_allowed_html( 'post' );

?>

<!-- Footer Style -->
<footer class="main-footer">
    <div class="footer_bg-image" <?php if($footer_shape_image) { ?> style="background-image: url(<?php echo esc_url($footer_shape_image); ?>)"<?php } ?>></div>
    <?php if($options->get('show_footer_v1_newsletter_form')){ ?>
    <div class="upper-box">
        <div class="auto-container">
            <div class="row clearfix">
                <?php if($footer_logo_image) { ?>
                <div class="column col-lg-6 col-md-6 col-sm-12">
                    <div class="footer-logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url($footer_logo_image); ?>" alt="<?php esc_attr_e('Awesome Image', 'antilia');?>"></a></div>
                </div>
                <?php } ?>
                <?php if($options->get('show_footer_v1_newsletter_form')){ ?>
                <div class="column col-lg-6 col-md-6 col-sm-12">
                    <!-- Subscribe Box -->
                    <div class="subscribe-box">
                        <?php echo do_shortcode($options->get('footer_v1_newsletter_url')); ?>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php } ?>
    <?php if ( is_active_sidebar( 'footer-sidebar' ) ) { ?>
    <!-- Widgets Section -->
    <div class="widgets-section">
        <div class="auto-container">
            <div class="row clearfix">
				<?php dynamic_sidebar( 'footer-sidebar' ); ?>
            </div>
        </div>
    </div>
    <!-- End Widgets Section -->
	<?php } ?>
    <?php if($options->get( 'footer_v1_copyright_text' ) || $options->get('show_footer_v1_social_media')){?>
    <div class="footer-bottom">
        <div class="auto-container">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <div class="copyright"><?php echo wp_kses( $options->get( 'footer_v1_copyright_text'), $allowed_html ); ?></div>
                <?php if($options->get('show_footer_v1_social_media')){ ?>
                <!-- Social Box -->
                <ul class="footer_socials">
					<?php echo antilia_get_social_icon(); ?>
                </ul>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php } ?>
</footer>


