<?php
/**
 * Footer Template  File
 *
 * @package ANTILIA
 * @author  Codeliono
 * @version 1.0
 */

$options = antilia_WSH()->option();

$footer_shape_image_v2 = $options->get( 'footer_shape_image_v2' );
$footer_shape_image_v2 = antilia_set( $footer_shape_image_v2, 'url', ANTILIA_URI . '' );

$allowed_html = wp_kses_allowed_html( 'post' );

?>

<!-- Footer Style -->
<footer class="footer-style-two">
    <div class="footer-two_bg-image" <?php if($footer_shape_image_v2) { ?> style="background-image: url('<?php echo esc_url($footer_shape_image_v2); ?>')"<?php } ?>></div>
    <div class="auto-container">
        <?php if ( is_active_sidebar( 'footer-sidebar-2' ) ) { ?>
        <!-- Widgets Section -->
        <div class="widgets-section">
            <div class="row clearfix">
				<?php dynamic_sidebar( 'footer-sidebar-2' ); ?>
            </div>
        </div>
		<?php } ?>
        <?php if($options->get('show_footer_v2_newsletter_form')){ ?>
        <!-- Newsletter Box -->
        <div class="newsletter-box">
            <div class="row clearfix">
                <?php if($options->get('footer_v2_newsletter_title')){ ?>
                <div class="column col-lg-5 col-md-12 col-sm-12">
                    <h3><i class="fa fa-paper-plane"></i> <?php echo wp_kses( $options->get( 'footer_v2_newsletter_title'), true); ?></h3>
                </div>
                <?php } ?>
                <?php if($options->get('footer_v2_newsletter_url')){ ?>
                <div class="column col-lg-7 col-md-12 col-sm-12">
                    <!-- Subscribe Box -->
                    <div class="subscribe-box style-two">
                        <?php echo do_shortcode($options->get('footer_v2_newsletter_url')); ?>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
		<?php } ?>
		<?php if($options->get( 'footer_v2_copyright_text' ) || $options->get('show_footer_v2_social_media')){?>
        <div class="footer-bottom">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <?php if($options->get( 'footer_v2_copyright_text' )){?>
                <div class="copyright"><?php echo wp_kses( $options->get( 'footer_v2_copyright_text'), $allowed_html ); ?></div>
                <?php } ?>
                <?php if($options->get('show_footer_v2_social_media')){ ?>
                <!-- Social Box -->
                <ul class="footer_socials">
                    <?php echo antilia_get_social_icon(); ?>
                </ul>
                <?php } ?>
            </div>
        </div>
		<?php } ?>
    </div>
</footer>

