<?php
/**
 * Footer Template  File
 *
 * @package ANTILIA
 * @author  Codeliono
 * @version 1.0
 */

$options = antilia_WSH()->option();

$footer_logo_image_v3 = $options->get( 'footer_logo_image_v3' );
$footer_logo_image_v3 = antilia_set( $footer_logo_image_v3, 'url', ANTILIA_URI . '' );

$footer_shape_image6 = $options->get( 'footer_shape_image6' );
$footer_shape_image6 = antilia_set( $footer_shape_image6, 'url', ANTILIA_URI . '' );

$allowed_html = wp_kses_allowed_html( 'post' );

?>

<?php if ( is_active_sidebar( 'footer-sidebar-3' ) ) { ?>
<!-- Footer Style -->
<footer class="footer-style-two">
    <div class="footer-two_bg-image" <?php if($footer_shape_image6) { ?>style="background-image: url(<?php echo esc_url($footer_shape_image6); ?>)"<?php } ?>></div>
    <div class="auto-container">
        <?php if ( is_active_sidebar( 'footer-sidebar-3' ) ) { ?>
        <!-- Widgets Section -->
        <div class="widgets-section">
            <div class="row clearfix">
				<?php dynamic_sidebar( 'footer-sidebar-3' ); ?>
            </div>
        </div>
		<?php } ?>
    </div>
    <?php if($footer_logo_image_v3 || $options->get( 'footer_v3_copyright_text' ) || $options->get('show_footer_v3_social_media')){?>
    <div class="footer-bottom">
        <div class="auto-container">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <?php if($footer_logo_image_v3) { ?><div class="footer-bottom_logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url($footer_logo_image_v3); ?>" alt="<?php esc_attr_e('Awesome Image', 'antilia');?>"></a></div><?php } ?>
                <?php if($options->get( 'footer_v3_copyright_text' )){?><div class="copyright"><?php echo wp_kses( $options->get( 'footer_v3_copyright_text'), $allowed_html ); ?></div><?php } ?>
                <?php if($options->get('show_footer_v3_social_media')){ ?>
                <!-- Social Box -->
                <ul class="footer_socials">
                    <?php echo antilia_get_social_icon(); ?>
                </ul>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php } ?>
</footer>

<?php } ?>
