<?php
$options = antilia_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Light Color Logo Settings
$light_color_logo = $options->get( 'light_color_logo' );
$light_color_logo_dimension = $options->get( 'light_color_logo_dimension' );

//Light Color Logo Settings
$small_light_color_logo = $options->get( 'small_light_color_logo' );
$small_light_color_logo_dimension = $options->get( 'small_light_color_logo_dimension' );


//Mobile Color Logo Settings
$mobile_color_logo = $options->get( 'mobile_color_logo' );
$mobile_color_logo_dimension = $options->get( 'mobile_color_logo_dimension' );



$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>
    
<!-- Main Header -->
<header class="main-header">
    <?php if($options->get('show_topbar_v1')){ ?>
    <!-- Header Top -->
    <div class="header-top">
        <div class="auto-container">
            <div class="inner-container">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <?php if($options->get('show_welcome_text_v1')){ ?>
                    <div class="header-top_text"><?php echo wp_kses($options->get('welcome_text_v1'), true); ?></div>
					<?php } ?>
                    <div class="right-box d-flex align-items-center flex-wrap">
                       <?php if($options->get('show_phone_no_v1')){ ?>
                        <!-- Info List -->
                        <ul class="header-top_list">
                            <li>
                                <span class="icon"><img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/icons/phone.png" alt="<?php esc_attr_e('Awesome Image', 'antilia');?>" /></span>
                                <a href="tel:<?php echo esc_attr($options->get('phone_number_v1')); ?>"> <?php echo wp_kses($options->get('phone_number_v1'), true); ?></a>
                            </li>
                        </ul>
                        <?php } ?>
                        <?php if($options->get('show_social_media_v1')){ ?>
                        <!-- Social Box -->
                        <ul class="header_socials">
                            <li><?php echo wp_kses($options->get('social_icon_title_v1'), true); ?></li>
                            <?php echo antilia_get_social_icon(); ?>
                        </ul>
                        <?php } ?>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    
    <!-- Header Upper -->
    <div class="header-upper">
        <div class="auto-container">
            <div class="inner-container">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    
                    <div class="logo-box">
                        <div class="logo"><?php echo antilia_logo( $logo_type, $light_color_logo, $light_color_logo_dimension, $logo_text, $logo_typography ); ?></div>
                        <div class="logo-2"><?php echo antilia_logo( $logo_type, $small_light_color_logo, $small_light_color_logo_dimension, $logo_text, $logo_typography ); ?></div>
                    </div>
                    
                    <div class="nav-outer">
                        <!-- Main Menu -->
                        <nav class="main-menu navbar-expand-md">
                            <div class="navbar-header">
                                <!-- Toggle Button -->    	
                                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                </button>
                            </div>                            
                            <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                                <ul class="navigation clearfix">
                                    <?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                        'container_class'=>'navbar-collapse collapse navbar-right',
                                        'menu_class'=>'nav navbar-nav',
                                        'fallback_cb'=>false,
                                        'items_wrap' => '%3$s',
                                        'container'=>false,
                                        'depth'=>'3',
                                        'walker'=> new Bootstrap_walker()
                                    ) ); ?>
                                </ul>
                            </div>
                        </nav>
                    </div>                    
                    <!-- Main Menu End-->
                    <div class="outer-box d-flex align-items-center flex-wrap">
                        <?php if($options->get('show_search_icon_v1')): ?>
                        <!-- Search Btn -->
                        <div class="search-box-btn search-box-outer"><span class="icon fa fa-search"></span></div>
						<?php endif; ?>
						<?php if($options->get('show_cart_icon_v1')): ?>
                        <!-- Nav Btn -->
                        <div class="nav-btn navSidebar-button">
                            <span class="hamburger">
                                <span class="top-bun"></span>
                                <span class="meat"></span>
                                <span class="bottom-bun"></span>
                            </span>
                        </div>
						<?php endif; ?>
                        <?php if($options->get('show_btn_info_v1')){ ?>
                        <!-- Button Box -->
                        <div class="header_button-box">
                            <a href="<?php echo esc_url($options->get('btn_link_v1')); ?>" class="theme-btn btn-style-one">
                                <span class="btn-wrap">
                                    <span class="text-one"><?php echo wp_kses($options->get('btn_title_v1'), true); ?></span>
                                    <span class="text-two"><?php echo wp_kses($options->get('btn_title_v1'), true); ?></span>
                                </span>
                            </a>
                        </div>
						<?php } ?>
                        <!-- Mobile Navigation Toggler -->
                        <div class="mobile-nav-toggler"><span class="fa fa-bars"></span></div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!--End Header Upper-->
    
    <!-- Mobile Menu  -->
    <div class="mobile-menu">
        <div class="menu-backdrop"></div>
        <div class="close-btn"><span class="icon flaticon-close-1"></span></div>
        
        <nav class="menu-box">
            <div class="nav-logo"><?php echo antilia_logo( $logo_type, $mobile_color_logo, $mobile_color_logo_dimension, $logo_text, $logo_typography ); ?></div>
            <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
        </nav>
    </div>
    <!-- End Mobile Menu -->           
</header>
<!-- main-header end -->
